﻿Type.registerNamespace('CtxWebPart');
var _webPartPageComponentId;

CtxWebPart.PageComponent = function CtxWebPart_PageComponent(webPartPcId) {
   this._webPartPageComponentId = webPartPcId;
   CtxWebPart.PageComponent.initializeBase(this);
}

CtxWebPart.PageComponent.prototype =
{
   // Page-Komponente initialisieren
   init: function CtxWebPart_PageComponent$init() { },

   // Liefert eine Liste der fokussierte Kommandos
   // Die Page-Komponente wird nur für diese Kommandos ausgeführt
   getFocusedCommands: function CtxWebPart_PageComponent$getFocusedCommands() {
      return ['CtxTab.Alert'];
   },

   // Liefert eine Liste der globalen Kommandos
   getGlobalCommands: function CtxWebPart_PageComponent$getGlobalCommands() {
      return [];
   },

   // Legt fest, ob die Page-Komponente einen Fokus empfangen darf
   isFocusable: function CtxWebPart_PageComponent$isFocusable() {
      return true;
   },

   // Legt die Kommandos fest, die von der Page-Komponente abgearbeitet werden
   canHandleCommand: function CtxWebPart_PageComponent$canHandleCommand(commandId) {
      if (commandId === 'CtxTab.Alert') {
         return true;
      }
   },

   // Arbeitet die Kommandos der Page-Komponente ab
   handleCommand: function CtxWebPart_PageComponent$handleCommand(commandId, properties, sequence) {
      if (commandId === 'CtxTab.Alert') {
         alert('Nachricht vom kontextuellen Tab!');
      }
   },

   // Gibt die ID der Page-Komponente zurück
   getId: function CtxWebPart_PageComponent$getId() {
      return this._webPartPageComponentId;
   }
}

CtxWebPart.PageComponent.registerClass('CtxWebPart.PageComponent', CUI.Page.PageComponent);
SP.SOD.notifyScriptLoadedAndExecuteWaitingJobs("CtxWebPartExtensions.js");